/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.textfield;

import filenet.vw.toolkit.utils.uicontrols.textfield.IVWMaskElement;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskLiteral;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskMacros;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskParser;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskToken;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskTokenizer;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class VWMaskDocument
extends PlainDocument {
    private char m_templateChar;
    private VWMaskMacros m_macros = null;
    private Vector m_pattern = null;
    private int m_nMaxLength = 0;

    public VWMaskDocument(String VWMask, VWMaskMacros macros, char templateChar) {
        this.m_templateChar = templateChar;
        this.m_macros = macros;
        this.parse(VWMask);
    }

    public void insertString(int pos, String text, AttributeSet attr) throws BadLocationException {
        boolean bOkToAdd = true;
        if (text.length() == 0) {
            return;
        }
        if (pos + text.length() > this.m_nMaxLength) {
            throw new BadLocationException("The string is too long", pos);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (this.match(pos + i, text.charAt(i))) continue;
            bOkToAdd = false;
        }
        if (bOkToAdd) {
            super.insertString(pos, text, attr);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void parse(String text) {
        VWMaskTokenizer tokenizer = new VWMaskTokenizer("&|![](){} ", "");
        VWMaskParser parser = new VWMaskParser();
        this.m_pattern = new Vector();
        tokenizer.tokenize(text);
        while (tokenizer.hasMoreTokens()) {
            this.parseElement(tokenizer, parser);
        }
        this.m_nMaxLength = this.m_pattern.size();
    }

    private void parseElement(VWMaskTokenizer tokenizer, VWMaskParser parser) {
        VWMaskToken next = tokenizer.nextToken();
        if (next.equals('{')) {
            this.m_pattern.addElement(parser.parseCondition(tokenizer));
            VWMaskParser.expect(tokenizer.nextToken(), '}');
        } else {
            String text = next.m_text;
            for (int i = 0; i < text.length(); ++i) {
                this.m_pattern.addElement(new VWMaskLiteral(text.charAt(i)));
            }
        }
    }

    private String getTemplate() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.m_nMaxLength; ++i) {
            buffer.append(this.getTemplateChar(i));
        }
        return buffer.toString();
    }

    private char getTemplateChar(int pos) {
        char literal;
        char result = this.m_templateChar;
        IVWMaskElement rule = this.getRule(pos);
        if (rule instanceof VWMaskLiteral && !this.m_macros.containsMacro(literal = ((VWMaskLiteral)rule).m_chr)) {
            result = literal;
        }
        return result;
    }

    private IVWMaskElement getRule(int index) {
        IVWMaskElement result = null;
        try {
            if (index < this.m_nMaxLength) {
                result = (IVWMaskElement)this.m_pattern.elementAt(index);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private boolean match(int pos, char chr) {
        boolean result = false;
        IVWMaskElement element = this.getRule(pos);
        if (element != null) {
            char macro;
            result = element.match(chr);
            if (element instanceof VWMaskLiteral && this.m_macros.containsMacro(macro = ((VWMaskLiteral)element).m_chr)) {
                result = this.m_macros.getMacro(macro).match(chr);
            }
        }
        return result;
    }
}

